(function($){
  function escCss(val){
    if (typeof val !== 'string') return '';
    // Keep it permissive, but avoid breaking the style attribute.
    return val.replace(/[^#(),.\-\w\s%/]/g, '');
  }

  function getPresets(){
    return (window.WARSTYLES_ADMIN && window.WARSTYLES_ADMIN.presets) ? window.WARSTYLES_ADMIN.presets : {};
  }

  function setStatus($grid, msg){
    var $s = $grid.find('.warstyles-status');
    if (!$s.length) return;
    $s.stop(true, true)
      .text(msg)
      .css({opacity: 1})
      .delay(1200)
      .animate({opacity: 0}, 400);
  }

  function clearColorInput($input){
    var $wrap = $input.closest('.wp-picker-container');
    var $clear = $wrap.find('.wp-picker-clear');
    if ($clear.length) {
      $clear.trigger('click');
      return;
    }
    $input.val('');
    $input.trigger('change');
  }

  function collectVars($grid){
    var presets = getPresets();
    var presetKey = ($grid.find('#warstyles_preset').val() || 'warchief').toString();
    var preset = presets[presetKey] || {};

    var vars = $.extend({}, (preset.vars || {}));

    var map = {
      '#warstyles_accent': '--wf-accent',
      '#warstyles_form_text': '--wf-form-text',
      '#warstyles_label': '--wf-label',
      '#warstyles_field_bg': '--wf-field-bg',
      '#warstyles_field_text': '--wf-field-text',
      '#warstyles_field_border': '--wf-field-border',
      '#warstyles_placeholder': '--wf-placeholder',
      '#warstyles_form_bg': '--wf-form-bg',
      '#warstyles_form_bg2': '--wf-form-bg2',
      '#warstyles_form_border': '--wf-form-border',
      '#warstyles_button_bg': '--wf-button-bg',
      '#warstyles_button_text': '--wf-button-text',
      '#warstyles_button_border': '--wf-button-border'
    };

    $.each(map, function(sel, varName){
      var $el = $grid.find(sel);
      if (!$el.length) return;
      var val = ($el.val() || '').toString().trim();
      if (val !== '') {
        vars[varName] = val;
      }
    });

    return { presetKey: presetKey, vars: vars };
  }

  function applyPreview($grid){
    var $preview = $grid.find('#warstyles-preview-form');
    if (!$preview.length) return;

    var enabled = $grid.find('input[name="warstyles_enabled"]').is(':checked');
    var bgMode = ($grid.find('#warstyles_bg_mode').val() === 'gradient') ? 'gradient' : 'solid';
    var stretch = $grid.find('#warstyles_stretch').is(':checked');

    var data = collectVars($grid);

    var style = '';
    if (data.vars) {
      Object.keys(data.vars).forEach(function(k){
        var v = data.vars[k];
        if (v === null || typeof v === 'undefined') return;
        v = String(v).trim();
        if (!v) return;
        style += k + ':' + escCss(v) + ';';
      });
    }

    $preview.attr('style', style);

    // Preset class swap.
    $preview.removeClass(function(i, cls){
      var m = cls.match(/\bwarstyles-preset-[^\s]+/g);
      return m ? m.join(' ') : '';
    });
    $preview.addClass('warstyles-preset-' + data.presetKey);

    $preview.toggleClass('warstyles-bg-gradient', bgMode === 'gradient');
    $preview.toggleClass('warstyles-stretch', !!stretch);
    $preview.toggleClass('is-disabled', !enabled);
  }


  function initSubtabs($grid){
    var $tabs = $grid.find('.warstyles-subtabs .nav-tab');
    if (!$tabs.length) return;

    var formId = $grid.data('warstyles-form-id') || '';
    var storageKey = 'warstyles_active_view_' + formId;

    function setView(view){
      if (!view) view = 'controls';
      if (!$grid.find('.warstyles-subview-' + view).length) view = 'controls';

      $grid.removeClass('warstyles-view-controls warstyles-view-preview warstyles-view-css')
           .addClass('warstyles-view-' + view);

      $tabs.removeClass('nav-tab-active');
      $tabs.filter('[data-warstyles-view="' + view + '"]').addClass('nav-tab-active');

      applyPreview($grid);
    }

    // Restore last view (if any) after the controls initialize.
    var initial = 'controls';
    try {
      if (window.localStorage) {
        initial = localStorage.getItem(storageKey) || 'controls';
      }
    } catch (e) {}
    setView(initial);

    $tabs.on('click', function(e){
      e.preventDefault();
      var view = ($(this).data('warstyles-view') || '').toString();
      if (!view) return;
      setView(view);
      try {
        if (window.localStorage) localStorage.setItem(storageKey, view);
      } catch (e) {}
    });
  }



  function initGrid($grid){
    // Init WP color picker.
    $grid.find('.warstyles-color').each(function(){
      var $input = $(this);
      if ($input.data('wpColorPicker')) return;
      $input.wpColorPicker({
        change: function(){ applyPreview($grid); },
        clear: function(){ applyPreview($grid); }
      });
    });

    // Live update.
    $grid.on('change keyup', 'input.warstyles-color, #warstyles_bg_mode, #warstyles_stretch, input[name="warstyles_enabled"]', function(){
      applyPreview($grid);
    });

    // Selecting a preset should override any existing selections.
    $grid.on('change', '#warstyles_preset', function(){
      $grid.find('.warstyles-color').each(function(){
        clearColorInput($(this));
      });
      applyPreview($grid);
      setStatus($grid, 'Preset applied (overrides cleared)');
    });

    // Manual reset button.
    $grid.on('click', '.warstyles-reset-overrides', function(e){
      e.preventDefault();
      $grid.find('.warstyles-color').each(function(){
        clearColorInput($(this));
      });
      applyPreview($grid);
      setStatus($grid, 'Overrides cleared');
    });

    // Initial render.
    applyPreview($grid);
    initSubtabs($grid);
  }

  $(function(){
    $('.warstyles-builder-grid').each(function(){
      initGrid($(this));
    });
  });
})(jQuery);
